document.addEventListener("DOMContentLoaded", function() {
  const runCommandBtn = document.getElementById("runCommandBtn");
  const terminalInput = document.getElementById("terminalInput");
  const terminalOutput = document.getElementById("terminalOutput");

  runCommandBtn.addEventListener("click", function() {
    const input = terminalInput.value;
    // Buat baris output untuk perintah yang dimasukkan
    const inputLine = document.createElement("div");
    // Untuk keamanan, kita mengganti karakter '<' dan '>' agar tidak dieksekusi sebagai HTML
    const sanitizedInput = input.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    inputLine.innerHTML = `<span class="text-green-600">$ ${sanitizedInput}</span>`;
    terminalOutput.appendChild(inputLine);
    
    try {
      // Menggunakan Function sebagai sandbox sederhana (tetap berhati-hati dengan penggunaan ini)
      let result = Function('"use strict"; return (' + input + ')')();
      const resultLine = document.createElement("div");
      resultLine.textContent = result;
      resultLine.classList.add("text-gray-800");
      terminalOutput.appendChild(resultLine);
    } catch (err) {
      const errorLine = document.createElement("div");
      errorLine.textContent = "Error: " + err.message;
      errorLine.classList.add("text-red-600");
      terminalOutput.appendChild(errorLine);
    }
    
    // Scroll output ke bawah agar hasil terbaru terlihat
    terminalOutput.scrollTop = terminalOutput.scrollHeight;
  });
});
