// app.js

require('dotenv').config();
const express = require('express');
const path = require('path');
const session = require('express-session');

const app = express();

// Konfigurasi session
app.use(session({
  secret: process.env.SESSION_SECRET || 'your-default-secret',
  resave: false,
  saveUninitialized: false
}));

// Parsing request body
app.use(express.urlencoded({ extended: true }));
app.use(express.json());

// Set view engine dan lokasi folder views
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Folder untuk aset statis (CSS, JS, images, dll)
app.use(express.static(path.join(__dirname, 'public')));

// Integrasi rute utama
const routes = require('./routes/index');
app.use('/', routes);

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Server berjalan di http://localhost:${PORT}`);
});
