const Materi = require('../models/Materi');

const materiController = {
  // Tampilkan daftar semua materi
  index: (req, res) => {
    Materi.getAll((err, results) => {
      if (err) {
        console.error(err);
        return res.render('pages/materi', { 
          title: 'Materi Pembelajaran', 
          error: 'Terjadi kesalahan, silakan coba lagi.', 
          materi: [] 
        });
      }
      res.render('pages/materi', { 
        title: 'Materi Pembelajaran', 
        materi: results, 
        error: null 
      });
    });
  },

  // Tampilkan detail satu materi
  detail: (req, res) => {
    const materiId = req.params.id;
    Materi.getById(materiId, (err, results) => {
      if (err || results.length === 0) {
        return res.render('pages/materiDetail', { 
          title: 'Detail Materi', 
          error: 'Materi tidak ditemukan', 
          materi: null 
        });
      }
      res.render('pages/materiDetail', { 
        title: 'Detail Materi', 
        materi: results[0], 
        error: null 
      });
    });
  }
};

module.exports = materiController;
