const db = require('../config/db');
const Quiz = require('../models/Quiz');

/**
 * Menampilkan daftar materi yang memiliki quiz.
 */
exports.listMateri = (req, res) => {
  const query = `SELECT * FROM materi WHERE id IN (SELECT DISTINCT materi_id FROM quiz)`;
  db.query(query, (err, results) => {
    if (err) {
      console.error("Error mengambil data materi:", err);
      return res.status(500).send("Terjadi kesalahan saat mengambil data materi.");
    }
    res.render('pages/quizMateriList', { materi: results });
  });
};

/**
 * Menampilkan halaman quiz berdasarkan materiId.
 */
exports.getQuiz = async (req, res) => {
  try {
    const materiId = req.params.materiId;
    const quizQuestions = await Quiz.getByMateriId(materiId);
    const user = req.session.user || { username: "Guest" };

    res.render('pages/quiz', { quizQuestions, materiId, submitted: false, user });
  } catch (error) {
    console.error("Error menampilkan quiz:", error);
    res.status(500).send("Terjadi kesalahan pada server saat menampilkan quiz.");
  }
};

/**
 * Memproses jawaban quiz dan menghitung skor.
 */
exports.submitQuiz = async (req, res) => {
  try {
    const materiId = req.params.materiId;
    const userAnswers = req.body.answers || {};
    const questionIds = req.body.question_ids || [];
    const user = req.session.user || { username: "Guest" };

    // Ambil jawaban benar dari database
    const correctAnswers = await Quiz.getByMateriId(materiId);

    let correctCount = 0;
    let totalQuestions = correctAnswers.length;

    correctAnswers.forEach((question) => {
      if (question.id === 0) return; // Abaikan ID 0

      const userAnswer = userAnswers[question.id] ? userAnswers[question.id].trim().toLowerCase() : "";
      const correctAnswer = question.jawaban.trim().toLowerCase();

      console.log(`DEBUG: ID ${question.id} | User: "${userAnswer}" | Correct: "${correctAnswer}"`);

      if (userAnswer === correctAnswer) {
        correctCount++;
      }
    });

    const score = totalQuestions > 0 ? Math.round((correctCount / totalQuestions) * 100) : 0;

    res.render('pages/quiz', {
      quizQuestions: correctAnswers,
      materiId,
      submitted: true,
      score,
      user
    });
  } catch (error) {
    console.error("Error saat submit quiz:", error);
    res.status(500).send("Terjadi kesalahan pada server saat submit quiz.");
  }
};
