// models/User.js
const db = require('../config/db');
const bcrypt = require('bcrypt');

const User = {
  // Membuat user baru dengan password yang di-hash
  create: (data, callback) => {
    const hashedPassword = bcrypt.hashSync(data.password, 10);
    const query = 'INSERT INTO users (username, email, password) VALUES (?, ?, ?)';
    db.query(query, [data.username, data.email, hashedPassword], callback);
  },
  // Mencari user berdasarkan email
  findByEmail: (email, callback) => {
    const query = 'SELECT * FROM users WHERE email = ?';
    db.query(query, [email], callback);
  }
};

module.exports = User;
